#!/bin/sh
prefix=/usr
incdir=${prefix}/include
libdir=${prefix}/lib
bindir=${prefix}/bin
tscriptname=`basename $0`
VER=`echo $tscriptname | sed -e 's/^[[:alpha:]]*\([[:digit:]\.]*\)-devel\.sh/\1/'`
VERMAJ=`echo $VER | sed -e 's/^\([[:alnum:]]*\)\..*$/\1/'`
VERMIN=`echo $VER | sed -e 's/^.*\.\([[:alnum:]]*\).*$/\1/'`
cd ${incdir}
  rm -rf db${VERMAJ}
  ln -sf db${VERMAJ}.${VERMIN} db${VERMAJ}
  rm -f db.h
  ln -sf db${VERMAJ}.${VERMIN}/db.h db.h
cd ${libdir}
  for fn in libdb*-${VERMAJ}.${VERMIN}.dll.a ; do
    base_fn=${fn%-${VERMAJ}.${VERMIN}.dll.a}
    if [ -f $fn ] ; then
      rm -f ${base_fn}.dll.a
      ln -fs ${fn} ${base_fn}.dll.a
    fi
  done
  for fn in libdb*-${VERMAJ}.${VERMIN}.la ; do
    base_fn=${fn%-${VERMAJ}.${VERMIN}.la}
    if [ -f $fn ] ; then
      rm -f ${base_fn}.la
      ln -fs ${fn} ${base_fn}.la
    fi
  done
  for fn in libdb*-${VERMAJ}.${VERMIN}.a ; do
    base_fn=${fn%-${VERMAJ}.${VERMIN}.a}
    if [ -f $fn ] ; then
      rm -f ${base_fn}.a
      ln -fs ${fn} ${base_fn}.a
    fi
  done
cd ${bindir}
  for fn in db${VERMAJ}.${VERMIN}_*.exe ; do
    linkfn=`echo $fn | sed "s,^db${VERMAJ}\.${VERMIN}_,db_,"`
    rm -f ${linkfn}
    ln -sf ${fn} ${linkfn}
  done
