#!perl -w
# $Id: pc2unix.pl,v 1.3 2004/09/30 07:34:13 jlinoff Exp $
#
# Convert PC files to UNIX by stripping of the trailing w/s.
#
# perl pc2unix.pl <file1> <file2> ...
#
use strict;

my $arg;
foreach $arg (@ARGV) {
    next if( ! -w $arg);
    next if( -d $arg);
    next if( $arg =~ /.o$/ );
    next if( $arg =~ /.obj$/ );
    next if( $arg =~ /.exe$/ );

    # ================================================
    # Read the file and store the lines so
    # that we can write them back out to the
    # same file.
    # ================================================
    my @lines = ();
    open(HND,"$arg") || die "ERROR: Can't read '$arg'.\n";
    binmode HND;
    my $bin_flag = 0;
    while(<HND>) {
	if( /\r/ ) {
	    $bin_flag = 1;
	    s/\r//;
	    push @lines,$_;
	}
    }
    close(HND);

    # ================================================
    # Write out the file if it was a binary file.
    # ================================================
    if( $bin_flag ) {
	print "$arg\n";
	my $line;
	open(HND,">$arg") || die "ERROR: Can't write '$arg'.\n";
	binmode HND;
	foreach $line (@lines) {
	    print HND "$line";
	}
	close(HND);
    }
}

