// Verify the fix for issue 0183.

class test88
{
public:
   static bool IsHidden(const Block*);
   static bool IsHidden(const Network*);
   static bool IsHidden(const Signal*);
   static bool IsTentative(const Block*);
   static bool IsTentative(const Network*);
   static bool IsTentative(const Signal*);
   enum TYPE { HIDDEN, TENTATIVE, REFERENCE };
   test88();
   ~test88();
   void Hide(Block*);
   void Hide(Network*);
   void Hide(Signal*);
   void AddTentative(Block*);
   void AddTentative(Network*);
   void AddTentative(Signal*);
   void RemoveTentative(Block*);
   void RemoveTentative(Network*);
   void RemoveTentative(Signal*);
   typedef std::vector<std::pair<Block*,Block*> > BlockPairs;
   void AddReference(Block* orig, Block* replica=NULL, const char* propstr=NULL);
   void RemoveReference(Block*, const char* propstr=NULL);
   Block* GetBlockByName(const char* blockname, TYPE t=HIDDEN);
   Block const* GetBlockByName(const char*, TYPE t=HIDDEN) const;
   typedef std::vector<Block*> BlockHolder;
   typedef std::vector<Network*> NetworkHolder;
   typedef std::vector<Signal*> SignalHolder;
   typedef BlockHolder::iterator BlockItr;
   typedef BlockHolder::const_iterator BlockCItr;
   typedef NetworkHolder::iterator NetworkItr;
   typedef NetworkHolder::const_iterator NetworkCItr;
   typedef SignalHolder::iterator SignalItr;
   typedef SignalHolder::const_iterator SignalCItr;
   const BlockHolder& GetHiddenBlocks() const;
   const NetworkHolder& GetHiddenNetworks() const;
   const SignalHolder& GetHiddenSignals() const;
   const BlockHolder& GetTentativeBlocks() const;
   const NetworkHolder& GetTentativeNetworks() const;
   const SignalHolder& GetTentativeSignals() const;
   const BlockHolder& GetReferenceBlocks(const char* propstr=NULL) const;
   void FetchReferenceBlocks(BlockPairs& h, const char* propstr=NULL) const;
   const BlockHolder* GetBlocksHandle(TYPE) const;
   const NetworkHolder* GetNetworksHandle(TYPE) const;
   const SignalHolder* GetSignalsHandle(TYPE) const;
   void AddTimingCorrelation(Block* src, Block* dst);
   void GetTimingCorrelation(Block*, BlockHolder&) const;
   bool Restore();
   bool Commit();
   void Debug() const;
private:
   class Impl;   
   Impl *m_impl;
   test88(const test88&);
   test88& operator=(const test88&);
};
