//@copyright_begin
// ================================================================
// Copyright Notice
// Copyright (C) 1998-2004 by Joe Linoff
// 
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL JOE LINOFF BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Comments and suggestions are always welcome.
// Please report bugs to http://ccdoc.sourceforge.net/ccdoc
// ================================================================
//@copyright_end
#include "log.h"
#include <fstream>

// ================================================================
// This variable allows the header version
// to be queried at runtime.
// ================================================================
namespace {
  char ccdoc_rcsid[] = "$Id: log.cc,v 1.6 2004/09/30 04:16:06 jlinoff Exp $";
}

// ================================================================
// Global log object.
// ================================================================
ccdoc::log ccdoc::s_log;

// ================================================================
// Constructor.
// ================================================================
ccdoc::log::log()
  : m_output_flag(true),
    m_warnings_flag(true),
    m_warnings(0),
    m_errors(0)
{
  m_os.push_back(&cout);
}
// ================================================================
// Destructor.
// ================================================================
ccdoc::log::~log() {
}
// ================================================================
// Insert stream.
// ================================================================
void ccdoc::log::insert(ostream* log) {
  if(log)
    m_os.push_back(log);
}
// ================================================================
// Insert log file.
// ================================================================
void ccdoc::log::insert(string& log) {
  ofstream* os = new ofstream(log.c_str());
  if(! (*os) ) {
    s_log << "ERROR: Log file '" << log << "' is invalid.\n";
  }
  m_os.push_back( os );
}
// ================================================================
// Remove ostream.
// ================================================================
void ccdoc::log::remove(ostream* os) {
  vector<ostream*>::iterator itr = m_os.begin();
  for( ; itr!=m_os.end(); ++itr) {
    if( *itr == os ) {
      // Only erase the 1st one.
      m_os.erase(itr);
      return;
    }
  }
}
// ================================================================
// operator << const char*
// ================================================================
ccdoc::log& ccdoc::log::flush() {
  if(m_output_flag) {
    vector<ostream*>::iterator i = m_os.begin();
    for( ; i!=m_os.end(); ++i) {
      ostream* os = *i;
      if(os) {
	os->flush();
      }
    }
  }
  return *this;
}
// ================================================================
// operator << const char*
// ================================================================
ccdoc::log& ccdoc::log::operator << (const char* str) {
  if(m_output_flag) {
    vector<ostream*>::iterator i = m_os.begin();
    for( ; i!=m_os.end(); ++i) {
      ostream* os = *i;
      if(os)
	(*os) << str;
    }
  }
  return *this;
}
// ================================================================
// operator << int
// ================================================================
ccdoc::log& ccdoc::log::operator << (int val) {
  if(m_output_flag) {
    vector<ostream*>::iterator i = m_os.begin();
    for( ; i!=m_os.end(); ++i) {
      ostream* os = *i;
      if(os) {
	(*os) << val;
      }
    }
  }
  return *this;
}
// ================================================================
// operator << unsigned int
// ================================================================
ccdoc::log& ccdoc::log::operator << (unsigned int val) {
  if(m_output_flag) {
    vector<ostream*>::iterator i = m_os.begin();
    for( ; i!=m_os.end(); ++i) {
      ostream* os = *i;
      if(os) {
	(*os) << val;
      }
    }
  }
  return *this;
}
// ================================================================
// operator << long
// ================================================================
ccdoc::log& ccdoc::log::operator << (long val) {
  if(m_output_flag) {
    vector<ostream*>::iterator i = m_os.begin();
    for( ; i!=m_os.end(); ++i) {
      ostream* os = *i;
      if(os) {
	(*os) << val;
      }
    }
  }
  return *this;
}
// ================================================================
// operator << unsigned long
// ================================================================
ccdoc::log& ccdoc::log::operator << (unsigned long val) {
  if(m_output_flag) {
    vector<ostream*>::iterator i = m_os.begin();
    for( ; i!=m_os.end(); ++i) {
      ostream* os = *i;
      if(os) {
	(*os) << val;
      }
    }
  }
  return *this;
}
// ================================================================
// operator << char
// ================================================================
ccdoc::log& ccdoc::log::operator << (char val) {
  if(m_output_flag) {
    vector<ostream*>::iterator i = m_os.begin();
    for( ; i!=m_os.end(); ++i) {
      ostream* os = *i;
      if(os) {
	(*os) << static_cast<char>(val);
      }
    }
  }
  return *this;
}
// ================================================================
// operator << unsigned char
// ================================================================
ccdoc::log& ccdoc::log::operator << (unsigned char val) {
  if(m_output_flag) {
    vector<ostream*>::iterator i = m_os.begin();
    for( ; i!=m_os.end(); ++i) {
      ostream* os = *i;
      if(os) {
	(*os) << static_cast<unsigned char>(val);
      }
    }
  }
  return *this;
}
// ================================================================
// operator << const string&
// ================================================================
ccdoc::log& ccdoc::log::operator << (const string& str) {
  *this << str.c_str();
  return *this;
}
// ================================================================
// operator << const vector<string>&
// ================================================================
ccdoc::log& ccdoc::log::operator << (const vector<string>& vec) {
  vector<string>::const_iterator itr = vec.begin();
  for(;itr!=vec.end();++itr) {
    *this << (*itr).c_str();
  }
  return *this;
}
// ================================================================
// operator <<
// ================================================================
ccdoc::log& ccdoc::log::operator << (ostream& (fct)(ostream&) ) {
  if(m_output_flag) {
    vector<ostream*>::iterator i = m_os.begin();
    for( ; i!=m_os.end(); ++i) {
      ostream* os = *i;
      if(os)
	(*os) << fct( *os );
    }
  }
  return *this;
}
// ================================================================
// Warning
// ================================================================
ccdoc::log& ccdoc::log::warning() {
  if(m_warnings_flag) {
    *this << "WARNING: ";
    m_warnings++;
    return *this;
  }
  return disable();
}
// ================================================================
// Error
// ================================================================
ccdoc::log& ccdoc::log::error() {
  *this << "ERROR: ";
  m_errors++;
  return *this;
}
