
# Find the input file.
case $# in
  0)
    case `ls configure.ac configure.in 2>/dev/null` in
      *ac*in )
        echo "$me: warning: both \`configure.ac' and \`configure.in' are present." >&2
        echo "$me: warning: proceeding with \`configure.ac'." >&2
        infile=configure.ac;;
      *ac ) infile=configure.ac;;
      *in ) infile=configure.in;;
      * )
      # if --version is supplied but no file is found, generate generic
      # version message.  First, call DEVEL --version, echo divider,
      # then call STABLE --version, another divider, and finally
      # an explanatory message.  That way, programs that try to
      # parse the output of --version won't be confused: they will
      # see DEVEL's version information and will discard everything else
      # (since they already discard all the license gobbledygook)
      #
      # On the other hand, if VER is already established (e.g. 
      # WANT_AUTOCONF_VER is set), then only print the "right" one.
      if [ -n "$SHORTCUT_DEVEL" ] ; then
        if [ -n "$opt_version" ] ; then
          ${AUTO_DEVEL}/bin/@PROGRAM@ --version
          exit 0
        elif [ -n "$opt_help" ] ; then
          ${AUTO_DEVEL}/bin/@PROGRAM@ --help
          exit 0
        else
          echo "$me: Couldn't find configure.ac nor configure.in file" >&2
          echo "run /usr/auto*/bin/@PROGRAM@ directly" >&2
          exit 1
        fi
      elif [ -n "$SHORTCUT_STABLE" ] ; then
        if [ -n "$opt_version" ] ; then
          ${AUTO_STABLE}/bin/@PROGRAM@ --version
          exit 0
        elif [ -n "$opt_help" ] ; then
          ${AUTO_STABLE}/bin/@PROGRAM@ --help
          exit 0
        else
          echo "$me: Couldn't find configure.ac nor configure.in file" >&2
          echo "run /usr/auto*/bin/@PROGRAM@ directly" >&2
          exit 1
        fi
      else
        if [ -n "$opt_version" ]; then
          ${AUTO_DEVEL}/bin/@PROGRAM@ --version
          echo "--------------------------------------------------------"
          ${AUTO_STABLE}/bin/@PROGRAM@ --version
          echo "--------------------------------------------------------"
          echo "This is @PROGRAM@-wrapper, which will hand off execution"
          echo "to one of the two real versions listed above, depending"
          echo "on the contents of configure.in/configure.ac.  Since the"
          echo "wrapper was called from within a directory in which those"
          echo "files are not found, this generic 'version' message is"
          echo "displayed."
          exit 0
        elif [ -n "$opt_help" ]; then
          ${AUTO_DEVEL}/bin/@PROGRAM@ --help
          echo ""
          echo "--------------------------------------------------------"
          echo "------ Above: 'devel' help.  Below: 'stable' help ------"
          echo "--------------------------------------------------------"
          echo ""
          ${AUTO_STABLE}/bin/@PROGRAM@ --help
          echo ""
          echo "--------------------------------------------------------"
          echo "------ Above: 'stable' help.  Below: 'wrapper' help ----"
          echo "--------------------------------------------------------"
          echo ""
          echo "This is @PROGRAM@-wrapper, which will hand off execution"
          echo "to one of the two real versions listed above, depending"
          echo "on the contents of configure.in/configure.ac.  Since the"
          echo "wrapper was called from within a directory in which those"
          echo "files are not found, this generic 'help' message is"
          echo "displayed."
          exit 0
        else
          echo "$me: Couldn't find configure.ac nor configure.in file" >&2
          echo "run /usr/auto*/bin/@PROGRAM@ directly" >&2
          exit 1
        fi
      fi
      ;;
    esac;;
  1) 
    case `ls ${1}/configure.ac ${1}/configure.in 2>/dev/null` in
      *ac*in )
        echo "$me: warning: both \`configure.ac' and \`configure.in' are present." >&2
        echo "$me: warning: proceeding with \`configure.ac'." >&2
        infile=${1}/configure.ac;;
      *ac ) infile=${1}/configure.ac;;
      *in ) infile=${1}/configure.in;;
      * )
        echo "$me: Couldn't find configure.ac nor configure.in file" >&2
        echo "run /usr/auto*/bin/@PROGRAM@ directly" >&2
        (exit 1); exit 1 ;;
    esac;;
  *) exec >&2
     echo "$me: invalid number of arguments."
     echo "$help"
     (exit 1); exit 1 ;;
esac

