#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export PKG2=libgd2
export PKG3=libgd-devel
export VER=`echo $tscriptname | sed -e "s/${PKG}\-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}\-${VER}\-//"`
export FULLPKG=${PKG}-${VER}-${REL}
export FULLPKG2=${PKG2}-${VER}-${REL}
export FULLPKG3=${PKG3}-${VER}-${REL}

# determine correct decompression option and tarball filename
if [ -e ${PKG}-${VER}.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e ${PKG}-${VER}.tgz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=tgz
elif [ -e ${PKG}-${VER}.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
else
  echo Cannot find original package.
  exit 1
fi

export src_orig_pkg_name=${PKG}-${VER}.tar.${src_orig_pkg_ext}
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export bin_pkg_name2=${FULLPKG2}.tar.bz2
export bin_pkg_name3=${FULLPKG3}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export bin_pkg2=${topdir}/${bin_pkg_name2}
export bin_pkg3=${topdir}/${bin_pkg_name3}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export configurelogfile=${topdir}/${FULLPKG}-CONFIGURE.LOG
export makelogfile=${topdir}/${FULLPKG}-MAKE.LOG
export checklogfile=${topdir}/${FULLPKG}-CHECK.LOG
export installlogfile=${topdir}/${FULLPKG}-INSTALL.LOG
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin

prefix=/usr
exec_prefix=${prefix}
sysconfdir=/etc
bindir=${prefix}/bin
sbindir=${prefix}/sbin
libexecdir=${sbindir}
libdir=${prefix}/lib
includedir=${prefix}/include
datadir=${prefix}/share
infodir=${datadir}/info
mandir=${datadir}/man
sharedstatedir=${prefix}/com
localstatedir=/var
cygdatadir=${prefix}/share
docdir=${cygdatadir}/doc/${PKG}-${VER}

MY_CPPFLAGS=""
MY_CFLAGS="-O2"
MY_LDFLAGS=""

pnoslash=`echo $prefix | sed -e 's#^/##'`
snoslash=`echo $sysconfdir | sed -e 's#^/##'`

mkdirs() {
  (cd ${topdir} && \
  rm -fr ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}
prep() {
  (cd ${topdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} ; \
  cd ${topdir} && \
  patch -p0 < ${src_patch} && \
# UNCOMMENT NEXT 3 LINES TO REMOVE GIF SUPPORT
# cd ${srcdir} && \
# patch -f -s -p1 -R < CYGWIN-PATCHES/${FULLPKG}-addgif.patch
# cd ${topdir} && \
  mkdirs )
}
bootstrap() {
  (cd ${srcdir}                                        && \
  libtoolize --automake --copy --force                 && \
  aclocal                                              && \
  automake --gnu --add-missing --force-missing --copy  && \
  autoconf                                             && \
  autoheader )
}
conf() {
  (cd ${objdir} && \
  lndir ../ && \
  rm -rf .build .inst .sinst CYGWIN-PATCHES && \
  CFLAGS="${MY_CFLAGS}"            \
  LDFLAGS="${MY_LDFLAGS}"          \
  ${srcdir}/configure              \
  --srcdir=${srcdir}               \
  --prefix=${prefix}               \
  --exec-prefix=${exec_prefix}     \
  --sysconfdir=${sysconfdir}       \
  --libdir=${libdir}               \
  --includedir=${includedir}       \
  --mandir=${mandir}               \
  --infodir=${infodir}             \
  --libexecdir=${libexecdir}       \
  --localstatedir=${localstatedir} \
  --datadir=${datadir}             \
  2>&1                             \
  | tee ${configurelogfile} )
}
build() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" make 2>&1 | tee ${makelogfile} )
}
check() {
  (cd ${objdir} && \
  make test 2>&1 | tee ${checklogfile} )
}
clean() {
  (cd ${objdir} && \
  make clean )
}
install() {
  (cd ${objdir} && \
  make install DESTDIR=${instdir} \
  2>&1                            \
  | tee -a ${installlogfile}   && \
  for f in ${prefix}/share/info/dir ${prefix}/info/dir ; do
    if [ -f ${instdir}${f} ] ; then \
      rm -f ${instdir}${f} ; \
    fi ;\
  done &&\
  for d in ${prefix}/share/doc/${PKG}-${VER} ${prefix}/share/doc/${PKG3}-${VER} \
    ${prefix}/share/doc/Cygwin ; do \
    if [ ! -d ${instdir}${d} ]; then \
      mkdir -p ${instdir}${d} ; \
    fi ;\
  done && \
  templist=""; \
  for f in                 \
    ${srcdir}/ABOUT*       \
    ${srcdir}/ANNOUNCE*    \
    ${srcdir}/AUTHOR*      \
    ${srcdir}/BUG*         \
    ${srcdir}/BUILDING     \
    ${srcdir}/changelog*   \
    ${srcdir}/changeLog*   \
    ${srcdir}/ChangeLog*   \
    ${srcdir}/changes*     \
    ${srcdir}/Changes*     \
    ${srcdir}/CHANGES*     \
    ${srcdir}/copying      \
    ${srcdir}/COPY*        \
    ${srcdir}/CREDIT*      \
    ${srcdir}/FAQ*         \
    ${srcdir}/FEATURES     \
    ${srcdir}/FILES        \
    ${srcdir}/FIXES        \
    ${srcdir}/HACKING      \
    ${srcdir}/HISTORY      \
    ${srcdir}/HOWTO*       \
    ${srcdir}/index.htm*   \
    ${srcdir}/INSTALL*     \
    ${srcdir}/LICENCE*     \
    ${srcdir}/LICENSE*     \
    ${srcdir}/MAINTAINER*  \
    ${srcdir}/MANIFEST     \
    ${srcdir}/*NEWS        \
    ${srcdir}/PLATFORM*    \
    ${srcdir}/PORTING      \
    ${srcdir}/PROBLEMS     \
    ${srcdir}/*readme*     \
    ${srcdir}/*Readme*     \
    ${srcdir}/*READ*ME*    \
    ${srcdir}/REL*NOTES*   \
    ${srcdir}/RELEASE      \
    ${srcdir}/SUPPORT      \
    ${srcdir}/TESTS        \
    ${srcdir}/THANKS       \
    ${srcdir}/TO*DO        \
    ${srcdir}/USAGE        \
    ${srcdir}/USERS
  do
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG}-${VER} ;
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG3}-${VER} ;
  fi && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
    ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG3}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
    ${instdir}${prefix}/share/doc/Cygwin/${PKG3}-${VER}.README && \
  if [ -f ${srcdir}/CYGWIN-PATCHES/postinstall.sh ] ; then \
    if [ ! -d ${instdir}${cygsysconfdir}/postinstall ] ; then
      mkdir -p ${instdir}${sysconfdir}/postinstall
    fi
    /usr/bin/install -m 755 ${srcdir}/CYGWIN-PATCHES/postinstall.sh \
        ${instdir}${sysconfdir}/postinstall/${PKG3}.sh
  fi )   
}
strip() {
  (cd ${instdir} && \
  find . -name "*.exe" -or -name "*.dll" | xargs strip > /dev/null 2>&1
  true )
}
list() {
  (cd ${instdir} && \
  find . -name "*" ! -type d | sed 's/\.\/\(.*\)/\1/'
  true )
}
listdep() {
  (cd ${instdir} && \
   find . -name '*.exe' -o -name '*.dll' | xargs cygcheck | \
     sed -e '/\.exe/d' -e 's,\\,/,g' | sort -bu | xargs -n1 cygpath -u | \
     xargs cygcheck -f | uniq
   true )
}
pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} \
    --exclude="${pnoslash}/bin/*.dll" \
    --exclude="${pnoslash}/bin/gdlib-config" \
    --exclude="${pnoslash}/include" \
    --exclude="${pnoslash}/lib" \
    --exclude="${pnoslash}/share/doc/${PKG3}*" \
    --exclude="${pnoslash}/share/doc/Cygwin/${PKG3}*" \
    * ; 
  tar cvjf ${bin_pkg2} ${pnoslash}/bin/*.dll ;
  tar cvjf ${bin_pkg3} \
    --exclude="${pnoslash}/bin/*.dll" \
    --exclude="${pnoslash}/bin/*.exe" \
    --exclude="${pnoslash}/bin/bdftogd" \
    ${pnoslash}/bin \
    ${pnoslash}/include \
    ${pnoslash}/lib \
    ${pnoslash}/share/doc/${PKG3}* \
    ${pnoslash}/share/doc/Cygwin/${PKG3}*
  )
}
mkpatch() {
  (cd ${srcdir} && \
  find . -name "autom4te.cache" | xargs rm -rf > /dev/null
  tar xv${opt_decomp}f ${src_orig_pkg} ;\
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -Naurp -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig )
}
spkg() {
  (cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * )
}
finish() {
  rm -rf ${srcdir}       && \
  rm ${configurelogfile} > /dev/null 2>&1
  rm ${makelogfile}      > /dev/null 2>&1
  rm ${checklogfile}     > /dev/null 2>&1
  rm ${installlogfile}   > /dev/null 2>&1 
}
case $1 in
  prep)	          prep ; STATUS=$? ;;
  mkdirs)       mkdirs ; STATUS=$? ;;
  bootstrap) bootstrap ; STATUS=$? ;;
  conf)	          conf ; STATUS=$? ;;
  build)         build ; STATUS=$? ;;
  check)         check ; STATUS=$? ;;
  clean)         clean ; STATUS=$? ;;
  install)     install ; STATUS=$? ;;
  list)	          list ; STATUS=$? ;;
  listdep)     listdep ; STATUS=$? ;;
  strip)         strip ; STATUS=$? ;;
  package)         pkg ; STATUS=$? ;;
  pkg)	           pkg ; STATUS=$? ;;
  mkpatch)     mkpatch ; STATUS=$? ;;
  src-package) 	  spkg ; STATUS=$? ;;
  spkg)	          spkg ; STATUS=$? ;;
  finish)       finish ; STATUS=$? ;;
  all) prep && mkpatch && bootstrap && conf && build && install && \
      strip && pkg && spkg && finish ; \
      STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
