import os

def get_first_word_of_line(filepath, line_number=1):
    try:
        with open(filepath, 'r', encoding='utf-8') as f:
            lines = f.readlines()
            if len(lines) >= line_number:
                line = lines[line_number - 1].strip()
                return line.split()[0] if line else ""
    except Exception as e:
        return f"(error: {e})"
    return "(not found)"

def main():
    # Set the base directory to the correct relative path
    base_dir = "../txts/hints"

    if not os.path.exists(base_dir):
        print(f"Error: The directory '{base_dir}' does not exist.")
        return

    for folder in os.listdir(base_dir):
        folder_path = os.path.join(base_dir, folder)
        if os.path.isdir(folder_path):
            # The folder variable already holds the language code (e.g., 'en', 'de')
            fname1 = os.path.join(folder_path, f"hints1_{folder}")
            fname2 = os.path.join(folder_path, f"hints2_{folder}")
            fname2_pre = os.path.join(folder_path, f"hints2_pre_gtk3_20_{folder}")
            fname3 = os.path.join(folder_path, f"hints3_{folder}")

            w1 = get_first_word_of_line(fname1, 1)
            w2 = get_first_word_of_line(fname2, 3)
            w3 = get_first_word_of_line(fname2_pre, 3)
            w4 = get_first_word_of_line(fname3, 3)

            print(f"{folder}: {w1} | {w2} | {w3} | {w4}")

if __name__ == "__main__":
    main()
