import os
import subprocess

# Directory containing .po files
PO_DIR = "../po"

# Directory containing the .pot file
POT_DIR = "../po/pot"

# Name of the .pot file
POT_FILE = "kickshaw.pot"

# Path to the .pot file
pot_file_path = os.path.join(POT_DIR, POT_FILE)

# Loop through all .po files in the PO_DIR
for po_file_name in os.listdir(PO_DIR):
    if po_file_name.endswith('.po'):
        po_file_path = os.path.join(PO_DIR, po_file_name)

        # Extract the language code from the file name
        lang, _ = os.path.splitext(po_file_name)

        # Run msgmerge command
        subprocess.run(["msgmerge", "--update", po_file_path, pot_file_path])

        print(f"Updated {lang}.po from {POT_FILE}")

print("All .po files have been updated.")
