/*
 * Decompiled with CFR 0.152.
 */
package jedecma;

import java.util.Date;
import javax.swing.JTextField;
import jedecma.FixedSizePlainDocument;
import jedecma.Jedecma;
import jedecma.Uti1;

class MyJTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    int type;
    float[] range;

    MyJTextField(int nrChr, String v, float[] r, int t) {
        this.setColumns(nrChr);
        this.range = r;
        this.type = t;
        if (Jedecma.jTextFieldFont != null) {
            this.setFont(Jedecma.jTextFieldFont);
        }
        this.setDocument(new FixedSizePlainDocument(nrChr));
        this.setText(v);
    }

    public boolean hasValidContent() {
        String ws = this.getText();
        switch (this.type) {
            case 1: {
                int i = 0;
                if (ws.length() > 0) {
                    try {
                        i = Integer.parseInt(ws);
                        if (this.range.length > 0 && ((float)i < this.range[0] || (float)i > this.range[1])) {
                            return false;
                        }
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                this.setText(String.valueOf(i));
                break;
            }
            case 2: {
                float f = 0.0f;
                if (ws.length() > 0) {
                    try {
                        f = Float.parseFloat(ws);
                        if (this.range.length > 0 && (f < this.range[0] || f > this.range[1])) {
                            return false;
                        }
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                this.setText(String.valueOf(f));
                break;
            }
            case 6: {
                String s = "";
                if (ws.length() <= 0) break;
                Date date = Uti1.string2Date(ws);
                if (date == null) {
                    return false;
                }
                this.setText(Uti1.date2String(date));
                break;
            }
            case 7: {
                this.setText(ws.toUpperCase());
                break;
            }
            case 8: {
                if (ws.length() <= 0) break;
                Date date = Uti1.fmtString2Date(ws, "MM/dd/yyyy");
                if (date == null) {
                    return false;
                }
                this.setText(Uti1.date2FmtString(date, "MM/dd/yyyy"));
            }
        }
        return true;
    }
}

